/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.hyperlink;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.contentAssist.ParsingUtils;
import com.aptana.editor.php.internal.contentAssist.mapping.ICodeLocation;
import com.aptana.editor.php.internal.contentAssist.mapping.PHPOffsetMapper;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.editor.php.util.EditorUtils;
import com.aptana.parsing.lexer.Lexeme;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class PHPHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String LINK_TEXT_FORMAT = "{0} [{1}]";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IEditorPart part = (IEditorPart)this.getAdapter(IEditorPart.class);
        if (!(part instanceof PHPSourceEditor)) {
            return null;
        }
        PHPSourceEditor editor = (PHPSourceEditor)part;
        return this.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
    }

    public IHyperlink[] detectHyperlinks(PHPSourceEditor editor, IRegion region, boolean canShowMultipleHyperlinks) {
        ILexemeProvider<PHPTokenType> lexemeProvider = ParsingUtils.createLexemeProvider(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()), region.getOffset());
        Lexeme lexeme = lexemeProvider.getLexemeFromOffset(region.getOffset());
        if (lexeme == null) {
            return null;
        }
        ArrayList<PHPHyperLink> result = new ArrayList<PHPHyperLink>();
        PHPOffsetMapper offsetMapper = editor.getOffsetMapper();
        Object[] codeLocations = offsetMapper.findTargets((Lexeme<PHPTokenType>)lexeme, lexemeProvider);
        if (!ArrayUtil.isEmpty((Object[])codeLocations)) {
            Region linkRegion = new Region(lexeme.getStartingOffset(), lexeme.getLength());
            Object[] objectArray = codeLocations;
            int n = codeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                Object codeLocation = objectArray[n2];
                String hyperLinkText = lexeme.getText();
                if (!StringUtil.isEmpty((String)codeLocation.getFullPath())) {
                    hyperLinkText = MessageFormat.format(LINK_TEXT_FORMAT, hyperLinkText, Path.fromOSString((String)codeLocation.getFullPath()).lastSegment());
                } else if (codeLocation.getRemoteFileStore() != null) {
                    hyperLinkText = MessageFormat.format(LINK_TEXT_FORMAT, hyperLinkText, codeLocation.getRemoteFileStore().getName());
                }
                PHPHyperLink link = new PHPHyperLink((ICodeLocation)codeLocation, (IRegion)linkRegion, hyperLinkText, "");
                result.add(link);
                ++n2;
            }
        }
        if (!result.isEmpty()) {
            return result.toArray(new IHyperlink[result.size()]);
        }
        return null;
    }

    static class PHPHyperLink
    implements IHyperlink {
        private IRegion region;
        private String hyperlinkText;
        private String typeLabel;
        private final ICodeLocation codeLocation;

        protected PHPHyperLink(ICodeLocation codeLocation, IRegion region, String hyperlinkText, String typeLabel) {
            this.codeLocation = codeLocation;
            this.region = region;
            this.hyperlinkText = hyperlinkText;
            this.typeLabel = typeLabel;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return this.hyperlinkText;
        }

        public String getTypeLabel() {
            return this.typeLabel;
        }

        public void open() {
            if (this.codeLocation == null) {
                return;
            }
            IFileStore remoteFileStore = this.codeLocation.getRemoteFileStore();
            Lexeme<PHPTokenType> startLexeme = this.codeLocation.getStartLexeme();
            if (remoteFileStore != null) {
                com.aptana.ide.ui.io.navigator.actions.EditorUtils.openFileInEditor((IFileStore)remoteFileStore, null, (TextSelection)new TextSelection(startLexeme.getStartingOffset(), startLexeme.getLength()));
            } else {
                this.openInEditor(this.codeLocation.getFullPath(), startLexeme);
            }
        }

        private void openInEditor(String fileName, Lexeme<PHPTokenType> lexeme) {
            File file = new File(fileName);
            IEditorPart part = null;
            if (file.exists()) {
                part = EditorUtils.openInEditor(file);
            } else {
                IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
                if (findMember != null && findMember.exists() && findMember instanceof IFile) {
                    part = EditorUtils.openInEditor(new File(((IFile)findMember).getLocationURI()));
                }
            }
            if (part instanceof AbstractTextEditor) {
                AbstractTextEditor editor = (AbstractTextEditor)part;
                editor.selectAndReveal(lexeme.getStartingOffset(), lexeme.getLength());
            }
        }
    }
}

